// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.25.0
// 	protoc        v3.13.0
// source: google/cloud/visualinspection/v1beta1/solution_artifact.proto

package visualinspection

import (
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// Export format types.
type SolutionArtifact_ExportType int32

const (
	// Unspecified by the user.
	SolutionArtifact_EXPORT_TYPE_UNSPECIFIED SolutionArtifact_ExportType = 0
	// A Docker-compatible container which runs on CPU only.
	SolutionArtifact_CPU_CONTAINER SolutionArtifact_ExportType = 1
	// A Docker-compatible container which runs on GPU.
	SolutionArtifact_GPU_CONTAINER SolutionArtifact_ExportType = 2
	// Packaged archive without the Docker container. It might include multiple
	// models, images, and other configuration files in one package.
	SolutionArtifact_PACKAGED_ARCHIVE SolutionArtifact_ExportType = 3
)

// Enum value maps for SolutionArtifact_ExportType.
var (
	SolutionArtifact_ExportType_name = map[int32]string{
		0: "EXPORT_TYPE_UNSPECIFIED",
		1: "CPU_CONTAINER",
		2: "GPU_CONTAINER",
		3: "PACKAGED_ARCHIVE",
	}
	SolutionArtifact_ExportType_value = map[string]int32{
		"EXPORT_TYPE_UNSPECIFIED": 0,
		"CPU_CONTAINER":           1,
		"GPU_CONTAINER":           2,
		"PACKAGED_ARCHIVE":        3,
	}
)

func (x SolutionArtifact_ExportType) Enum() *SolutionArtifact_ExportType {
	p := new(SolutionArtifact_ExportType)
	*p = x
	return p
}

func (x SolutionArtifact_ExportType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SolutionArtifact_ExportType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_visualinspection_v1beta1_solution_artifact_proto_enumTypes[0].Descriptor()
}

func (SolutionArtifact_ExportType) Type() protoreflect.EnumType {
	return &file_google_cloud_visualinspection_v1beta1_solution_artifact_proto_enumTypes[0]
}

func (x SolutionArtifact_ExportType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SolutionArtifact_ExportType.Descriptor instead.
func (SolutionArtifact_ExportType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_visualinspection_v1beta1_solution_artifact_proto_rawDescGZIP(), []int{0, 0}
}

// A SolutionArtifact is a fixed set of Models which can be exported or
// deployed.
type SolutionArtifact struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to ExportLocation:
	//	*SolutionArtifact_ContainerExportLocation
	//	*SolutionArtifact_PackagedArchiveGcsUri
	ExportLocation isSolutionArtifact_ExportLocation `protobuf_oneof:"export_location"`
	// Output only. Resource name for SolutionArtifact generated by the system.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Timestamp when this Module was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Required. A user friendly display name for the SolutionArtifact.
	// The name can be up to 128 characters long and can consist of any UTF-8
	// characters.
	DisplayName string `protobuf:"bytes,4,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// A description for this SolutionArtifact.
	Description string `protobuf:"bytes,5,opt,name=description,proto3" json:"description,omitempty"`
	// The labels with user-defined metadata to organize your SolutionArtifacts.
	//
	// Label keys and values can be no longer than 64 characters
	// (Unicode codepoints), can only contain lowercase letters, numeric
	// characters, underscores and dashes. International characters are allowed.
	// Label keys must start with a letter.
	//
	// See https://goo.gl/xmQnxf for more information on and examples of labels.
	Labels map[string]string `protobuf:"bytes,6,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// A list of Models to include in the exported solution. If this field is not
	// provided in the CreateSolutionArtifactRequest, the latest Model for every
	// Module will be exported. If provided, then only these Models are exported.
	// The list of models must comprise a complete solution according to the
	// expectations set by the Solution's SolutionType.
	Models []string `protobuf:"bytes,7,rep,name=models,proto3" json:"models,omitempty"`
	// Required. Export type.
	ExportType SolutionArtifact_ExportType `protobuf:"varint,8,opt,name=export_type,json=exportType,proto3,enum=google.cloud.visualinspection.v1beta1.SolutionArtifact_ExportType" json:"export_type,omitempty"`
}

func (x *SolutionArtifact) Reset() {
	*x = SolutionArtifact{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visualinspection_v1beta1_solution_artifact_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SolutionArtifact) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SolutionArtifact) ProtoMessage() {}

func (x *SolutionArtifact) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visualinspection_v1beta1_solution_artifact_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SolutionArtifact.ProtoReflect.Descriptor instead.
func (*SolutionArtifact) Descriptor() ([]byte, []int) {
	return file_google_cloud_visualinspection_v1beta1_solution_artifact_proto_rawDescGZIP(), []int{0}
}

func (m *SolutionArtifact) GetExportLocation() isSolutionArtifact_ExportLocation {
	if m != nil {
		return m.ExportLocation
	}
	return nil
}

func (x *SolutionArtifact) GetContainerExportLocation() *GcrDestination {
	if x, ok := x.GetExportLocation().(*SolutionArtifact_ContainerExportLocation); ok {
		return x.ContainerExportLocation
	}
	return nil
}

func (x *SolutionArtifact) GetPackagedArchiveGcsUri() string {
	if x, ok := x.GetExportLocation().(*SolutionArtifact_PackagedArchiveGcsUri); ok {
		return x.PackagedArchiveGcsUri
	}
	return ""
}

func (x *SolutionArtifact) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *SolutionArtifact) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *SolutionArtifact) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *SolutionArtifact) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *SolutionArtifact) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *SolutionArtifact) GetModels() []string {
	if x != nil {
		return x.Models
	}
	return nil
}

func (x *SolutionArtifact) GetExportType() SolutionArtifact_ExportType {
	if x != nil {
		return x.ExportType
	}
	return SolutionArtifact_EXPORT_TYPE_UNSPECIFIED
}

type isSolutionArtifact_ExportLocation interface {
	isSolutionArtifact_ExportLocation()
}

type SolutionArtifact_ContainerExportLocation struct {
	// Export location for the container. This must be specified when export
	// type is a CONTAINER type.
	ContainerExportLocation *GcrDestination `protobuf:"bytes,9,opt,name=container_export_location,json=containerExportLocation,proto3,oneof"`
}

type SolutionArtifact_PackagedArchiveGcsUri struct {
	// Export location for the packaged archive in the format like
	// gs://<BUCKET_NAME>/<OBJECT_NAME>.tar.gz. This must be specified when
	// export type is PACKAGED_ARCHIVE.
	PackagedArchiveGcsUri string `protobuf:"bytes,10,opt,name=packaged_archive_gcs_uri,json=packagedArchiveGcsUri,proto3,oneof"`
}

func (*SolutionArtifact_ContainerExportLocation) isSolutionArtifact_ExportLocation() {}

func (*SolutionArtifact_PackagedArchiveGcsUri) isSolutionArtifact_ExportLocation() {}

// The GCR location where the container will be pushed.
type GcrDestination struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Google Container Registry URI of the new image, up to
	// 2000 characters long. See
	//
	// https:
	// //cloud.google.com/container-registry/do
	// // cs/pushing-and-pulling#pushing_an_image_to_a_registry
	// Accepted forms:
	// * [HOSTNAME]/[PROJECT-ID]/[IMAGE]
	// * [HOSTNAME]/[PROJECT-ID]/[IMAGE]:[TAG]
	//
	// The requesting user must have permission to push images the project.
	OutputUri string `protobuf:"bytes,1,opt,name=output_uri,json=outputUri,proto3" json:"output_uri,omitempty"`
}

func (x *GcrDestination) Reset() {
	*x = GcrDestination{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visualinspection_v1beta1_solution_artifact_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GcrDestination) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GcrDestination) ProtoMessage() {}

func (x *GcrDestination) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visualinspection_v1beta1_solution_artifact_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GcrDestination.ProtoReflect.Descriptor instead.
func (*GcrDestination) Descriptor() ([]byte, []int) {
	return file_google_cloud_visualinspection_v1beta1_solution_artifact_proto_rawDescGZIP(), []int{1}
}

func (x *GcrDestination) GetOutputUri() string {
	if x != nil {
		return x.OutputUri
	}
	return ""
}

var File_google_cloud_visualinspection_v1beta1_solution_artifact_proto protoreflect.FileDescriptor

var file_google_cloud_visualinspection_v1beta1_solution_artifact_proto_rawDesc = []byte{
	0x0a, 0x3d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x76,
	0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2f,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12,
	0x25, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69,
	0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70,
	0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x22, 0x98, 0x07, 0x0a, 0x10, 0x53, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x72,
	0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x12, 0x73, 0x0a, 0x19, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69,
	0x6e, 0x65, 0x72, 0x5f, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69,
	0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x47, 0x63, 0x72, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x48, 0x00, 0x52, 0x17, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x45, 0x78, 0x70,
	0x6f, 0x72, 0x74, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x39, 0x0a, 0x18, 0x70,
	0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x64, 0x5f, 0x61, 0x72, 0x63, 0x68, 0x69, 0x76, 0x65, 0x5f,
	0x67, 0x63, 0x73, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52,
	0x15, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x64, 0x41, 0x72, 0x63, 0x68, 0x69, 0x76, 0x65,
	0x47, 0x63, 0x73, 0x55, 0x72, 0x69, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d,
	0x65, 0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x64, 0x69,
	0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73,
	0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b,
	0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x5b, 0x0a, 0x06, 0x6c,
	0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x43, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x75, 0x61,
	0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x53, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x72, 0x74, 0x69,
	0x66, 0x61, 0x63, 0x74, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x16, 0x0a, 0x06, 0x6d, 0x6f, 0x64, 0x65,
	0x6c, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x09, 0x52, 0x06, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x73,
	0x12, 0x68, 0x0a, 0x0b, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18,
	0x08, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x6f,
	0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x2e, 0x45,
	0x78, 0x70, 0x6f, 0x72, 0x74, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a,
	0x65, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x54, 0x79, 0x70, 0x65, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61,
	0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x65, 0x0a, 0x0a, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x54,
	0x79, 0x70, 0x65, 0x12, 0x1b, 0x0a, 0x17, 0x45, 0x58, 0x50, 0x4f, 0x52, 0x54, 0x5f, 0x54, 0x59,
	0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x11, 0x0a, 0x0d, 0x43, 0x50, 0x55, 0x5f, 0x43, 0x4f, 0x4e, 0x54, 0x41, 0x49, 0x4e, 0x45,
	0x52, 0x10, 0x01, 0x12, 0x11, 0x0a, 0x0d, 0x47, 0x50, 0x55, 0x5f, 0x43, 0x4f, 0x4e, 0x54, 0x41,
	0x49, 0x4e, 0x45, 0x52, 0x10, 0x02, 0x12, 0x14, 0x0a, 0x10, 0x50, 0x41, 0x43, 0x4b, 0x41, 0x47,
	0x45, 0x44, 0x5f, 0x41, 0x52, 0x43, 0x48, 0x49, 0x56, 0x45, 0x10, 0x03, 0x3a, 0x9a, 0x01, 0xea,
	0x41, 0x96, 0x01, 0x0a, 0x30, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x72, 0x74,
	0x69, 0x66, 0x61, 0x63, 0x74, 0x12, 0x62, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x73,
	0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69,
	0x6f, 0x6e, 0x7d, 0x2f, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x72, 0x74, 0x69,
	0x66, 0x61, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x7d, 0x42, 0x11, 0x0a, 0x0f, 0x65, 0x78, 0x70,
	0x6f, 0x72, 0x74, 0x5f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x34, 0x0a, 0x0e,
	0x47, 0x63, 0x72, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x22,
	0x0a, 0x0a, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x55,
	0x72, 0x69, 0x42, 0xff, 0x01, 0x0a, 0x29, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e,
	0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x50, 0x01, 0x5a, 0x55, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e,
	0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f,
	0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x3b, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69,
	0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0xaa, 0x02, 0x25, 0x47, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x56, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x49,
	0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x56, 0x31, 0x42, 0x65, 0x74, 0x61,
	0x31, 0xca, 0x02, 0x25, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64,
	0x5c, 0x56, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x49, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x5c, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0xea, 0x02, 0x28, 0x47, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x56, 0x69, 0x73, 0x75, 0x61,
	0x6c, 0x49, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x3a, 0x3a, 0x56, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_visualinspection_v1beta1_solution_artifact_proto_rawDescOnce sync.Once
	file_google_cloud_visualinspection_v1beta1_solution_artifact_proto_rawDescData = file_google_cloud_visualinspection_v1beta1_solution_artifact_proto_rawDesc
)

func file_google_cloud_visualinspection_v1beta1_solution_artifact_proto_rawDescGZIP() []byte {
	file_google_cloud_visualinspection_v1beta1_solution_artifact_proto_rawDescOnce.Do(func() {
		file_google_cloud_visualinspection_v1beta1_solution_artifact_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_visualinspection_v1beta1_solution_artifact_proto_rawDescData)
	})
	return file_google_cloud_visualinspection_v1beta1_solution_artifact_proto_rawDescData
}

var file_google_cloud_visualinspection_v1beta1_solution_artifact_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_cloud_visualinspection_v1beta1_solution_artifact_proto_msgTypes = make([]protoimpl.MessageInfo, 3)
var file_google_cloud_visualinspection_v1beta1_solution_artifact_proto_goTypes = []interface{}{
	(SolutionArtifact_ExportType)(0), // 0: google.cloud.visualinspection.v1beta1.SolutionArtifact.ExportType
	(*SolutionArtifact)(nil),         // 1: google.cloud.visualinspection.v1beta1.SolutionArtifact
	(*GcrDestination)(nil),           // 2: google.cloud.visualinspection.v1beta1.GcrDestination
	nil,                              // 3: google.cloud.visualinspection.v1beta1.SolutionArtifact.LabelsEntry
	(*timestamppb.Timestamp)(nil),    // 4: google.protobuf.Timestamp
}
var file_google_cloud_visualinspection_v1beta1_solution_artifact_proto_depIdxs = []int32{
	2, // 0: google.cloud.visualinspection.v1beta1.SolutionArtifact.container_export_location:type_name -> google.cloud.visualinspection.v1beta1.GcrDestination
	4, // 1: google.cloud.visualinspection.v1beta1.SolutionArtifact.create_time:type_name -> google.protobuf.Timestamp
	3, // 2: google.cloud.visualinspection.v1beta1.SolutionArtifact.labels:type_name -> google.cloud.visualinspection.v1beta1.SolutionArtifact.LabelsEntry
	0, // 3: google.cloud.visualinspection.v1beta1.SolutionArtifact.export_type:type_name -> google.cloud.visualinspection.v1beta1.SolutionArtifact.ExportType
	4, // [4:4] is the sub-list for method output_type
	4, // [4:4] is the sub-list for method input_type
	4, // [4:4] is the sub-list for extension type_name
	4, // [4:4] is the sub-list for extension extendee
	0, // [0:4] is the sub-list for field type_name
}

func init() { file_google_cloud_visualinspection_v1beta1_solution_artifact_proto_init() }
func file_google_cloud_visualinspection_v1beta1_solution_artifact_proto_init() {
	if File_google_cloud_visualinspection_v1beta1_solution_artifact_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_visualinspection_v1beta1_solution_artifact_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SolutionArtifact); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visualinspection_v1beta1_solution_artifact_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GcrDestination); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_visualinspection_v1beta1_solution_artifact_proto_msgTypes[0].OneofWrappers = []interface{}{
		(*SolutionArtifact_ContainerExportLocation)(nil),
		(*SolutionArtifact_PackagedArchiveGcsUri)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_visualinspection_v1beta1_solution_artifact_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   3,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_visualinspection_v1beta1_solution_artifact_proto_goTypes,
		DependencyIndexes: file_google_cloud_visualinspection_v1beta1_solution_artifact_proto_depIdxs,
		EnumInfos:         file_google_cloud_visualinspection_v1beta1_solution_artifact_proto_enumTypes,
		MessageInfos:      file_google_cloud_visualinspection_v1beta1_solution_artifact_proto_msgTypes,
	}.Build()
	File_google_cloud_visualinspection_v1beta1_solution_artifact_proto = out.File
	file_google_cloud_visualinspection_v1beta1_solution_artifact_proto_rawDesc = nil
	file_google_cloud_visualinspection_v1beta1_solution_artifact_proto_goTypes = nil
	file_google_cloud_visualinspection_v1beta1_solution_artifact_proto_depIdxs = nil
}
